/*
  A BajaScript Chat Application.
  Chat to anyone else using this App at the same time!
  Hit the run button to start listening. Enter any message
  below to and hit run to send.
*/

// Ensure the output Window doesn't get cleared when the run button is pressed...
bsconsole.clearOutputOnRun = false;

// Enter your user name and message here...
var userName = "John",
    message = "I Love BS!!!";

var sub = window.subscriber;

// If the Subscriber is already available then lazily create it
if (!sub) {
  sub = window.subscriber = new baja.Subscriber();
  sub.attach("topicFired", function(topic, event, cx) {
    // Output any messages fired
    baja.outln(event);
  });
}

// Resolve the App and fire the message
baja.Ord.make("service:testBajaScript:BajaScriptTutorialsApp").get({
  ok: function () {
    // If there's a message to send then fire it!
    if (message) {
      this.fireMessage(userName + " says " + message); 
    }
  },
  subscriber: sub
});
